/*
 * Copyright 2004 Caphyon LTD. All rights reserved.
 *
 * mailto: eng@caphyon.com
 * http://www.caphyon.com
 *
 */

#include "stdafx.h"

#define PIDKEY_LENGTH 100
#define DIGIT(a) ((a) - '0')

BOOL APIENTRY DllMain(HANDLE /*hModule*/, DWORD /*ul_reason_for_call*/, LPVOID /*lpReserved*/)
{
  return TRUE;
}

#ifndef _DEBUG
BOOL WINAPI __DllMainCRTStartup(HINSTANCE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
{
  return DllMain(hModule, ul_reason_for_call, lpReserved);
}
#endif

UINT __stdcall ValidateSerial_Sample(MSIHANDLE hInstall)
{
  TCHAR szPidKey[PIDKEY_LENGTH];
  DWORD dwLen = sizeof(szPidKey) / sizeof(szPidKey[0]);

  /// retrieve the text entered by the user
  UINT res = ::MsiGetProperty(hInstall, _T("PIDKEY"), szPidKey, &dwLen);
  if (res != ERROR_SUCCESS)
  {
    // fail the installation
    return 1;
  }

  bool snIsValid = true;
  // validate the text from szPidKey according to your algorithm
  // put the result in snIsValid

  // the template we use is <###-####> = <XYZ-ABCD>; # digit between 0 and 9
  // the algorithm is very simple (XY * Z + 7) * 13 = ABCD / 2
  int xy    = DIGIT(szPidKey[0]) * 10 + DIGIT(szPidKey[1]);
  int z     = DIGIT(szPidKey[2]);
  int left  = ((xy * z + 7) * 13) * 2;
  int right = DIGIT(szPidKey[4]);
  right     = right * 10 + DIGIT(szPidKey[5]);
  right     = right * 10 + DIGIT(szPidKey[6]);
  right     = right * 10 + DIGIT(szPidKey[7]);
  snIsValid = (left != 0) && (right != 0) && (left == right);

  const TCHAR * serialValid = nullptr;
  if (snIsValid)
    serialValid = _T("TRUE");
  else
  {
    // eventually say something to the user
    ::MessageBox(nullptr, _T("Invalid Serial Number"), _T("Message"), MB_ICONSTOP);

    serialValid = _T("FALSE");
  }

  res = ::MsiSetProperty(hInstall, _T("SERIAL_VALIDATION"), serialValid);
  if (res != ERROR_SUCCESS)
  {
    // fail the installation
    return 1;
  }

  // the validation succeeded - even the serial is wrong
  // if the SERIAL_VALIDATION was set to FALSE the installation will not continue
  return 0;
}
