/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.caphyon.service;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStreamReader;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

/**
 * Java Service Example
 */
public class JavaService {    
  static boolean running = true;
  // Command line arguments received when the service
  // is started.
  static String[] arguments;
  /*
   * Prints Hello to client and close the connection  
   */
  private static class ReaderThread extends Thread {
    private Socket clientSock;
    private PrintWriter output;
    private BufferedReader input;
    
    public ReaderThread(Socket sock, InputStream in, OutputStream out) {
      clientSock = sock;
      output = new PrintWriter(out);
      input = new BufferedReader(new InputStreamReader(in));
    }
    
    public void run() {
      try 
      {        
        output.write("Java Service is running.\r\n");
        output.write("Java Service start parameters:\r\n");
        for (int i = 0; i < arguments.length; ++i)
        {
          if ( i > 0 )
          {
            output.write(", ");
          }
          output.write(arguments[i]);
        }
        output.flush();          
      }
      catch(Exception ex) 
      {}
      finally 
      {
        try 
        {
          clientSock.close();    
        }
        catch(IOException ex)
        {}
      }
    }
  }
  
  /**
   * @param args the command line arguments
   */
  public static void main(String[] argv) 
  {
    try 
    {
      // store the command line arguments
      arguments = argv;
      // listen to the port 4444
      ServerSocket serv = new ServerSocket(4444);
      serv.setSoTimeout(3000);
      Socket client = null;
      
      while (running) 
      {        
        try 
        {
          client = serv.accept();
          if (client != null) 
          {             
            ReaderThread t = new ReaderThread(client, client.getInputStream(), 
              client.getOutputStream());
            t.start();            
          }
        }
        catch(SocketTimeoutException timeOutEx) {}          
      }          
    }
    catch(Throwable ex) {}
  }
  
  public static void stop() 
  {
    running = false;
  }
}
