﻿Imports System.Runtime.InteropServices
Imports System.Text

Public Class Form1

  ' This function does all the work
  <DllImport("Trial.dll", EntryPoint:="ReadSettingsStr", CharSet:=CharSet.Ansi)>
  Private Shared Function InitTrial(ByVal aKeyCode As String, ByVal aHWnd As IntPtr) As UInteger
  End Function

  ' Use this function to register the application when the application is running
  <DllImport("Trial.dll", EntryPoint:="DisplayRegistrationStr", CharSet:=CharSet.Ansi)>
  Private Shared Function DisplayRegistration(ByVal aKeyCode As String, ByVal aHWnd As IntPtr) As UInteger
  End Function

  ' Use this function to retrieve trial and license properties after the licensing have been initialized
  <DllImport("Trial.dll", EntryPoint:="GetPropertyValue", CharSet:=CharSet.Unicode)>
  Private Shared Function GetPropertyValue(ByVal aPropName As String, ByVal aResult As StringBuilder, ByRef _
 aResultLen As UInt32) As UInteger
  End Function

  ' The kLibraryKey is meant to prevent unauthorized use of the library.
  ' Do not share this key. Replace this key with your own from Advanced Installer
  ' project > Licensing > Registration > Library Key
  Private Shared kLibraryKey As String = "DCC71DB7B6BEF71C9858B5624362486AE0F7D9"

  ' The register state of the application which is computed when the form is loaded
  Private registered As Boolean

  Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    Try
      Dim Proc As Process = Process.GetCurrentProcess()

      ' This call will display the trial dialogs if needed
      Dim ret = InitTrial(kLibraryKey, Proc.MainWindowHandle)

      ' 0 return code means that the application is registered using a valid code, otherwise is in trial
      If ret = 0 Then
        registered = True
      End If

      ' Let's retrieve some property from the licensing configuration
      Dim val As StringBuilder = New StringBuilder
      Dim len As UInt32 = CType(val.Capacity, UInt32)
      If GetPropertyValue("TrialName", val, len) = 234 Then
        val = New StringBuilder(CType(len, Int32))
        GetPropertyValue("TrialName", val, len)
      End If
      Debug.WriteLine(val)

    Catch ex As Exception
      MessageBox.Show(ex.ToString())
      Process.GetCurrentProcess().Kill()
    End Try

  End Sub

  Private Sub DoRegister()
    Try
      Dim Proc As Process = Process.GetCurrentProcess()
      Dim ret = DisplayRegistration(kLibraryKey, Proc.MainWindowHandle)

      ' 0 return code means that the application was already registered or it
      ' has just been registered, otherwise is in trial
      If ret = 0 Then
        registered = True
      End If
    Catch ex As Exception
      MessageBox.Show(ex.ToString())
      Close()
    End Try
  End Sub

  Private Sub AboutToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AboutToolStripMenuItem.Click
    Dim dlg As AboutBox1 = New AboutBox1

    ' Set the about box member to the registered state computed when the application loaded
    dlg.registered = Me.registered

    ' Display the  About box
    dlg.Show()
  End Sub

  Private Sub RegisterToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RegisterToolStripMenuItem.Click
    If registered Then
      MessageBox.Show("The application is already registered.", "Registered", MessageBoxButtons.OK, MessageBoxIcon.Information)
    Else
      DoRegister()
    End If
  End Sub
End Class
