// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "InitTrial.h"
#include "TrialTestExampleView.h"

#define UM_TRIAL WM_USER + 100

#define kLibraryKey "ECEB5E5E3409A8BCAD544A344B4EA883BD782E7870AC4E8C60B1105FCE02F898BAA30905D069"

#define LICENSE_PROP_ID L"ID"
#define LICENSE_PROP_MP L"MP"
#define LICENSE_PROP_COMP_ID L"COMP_ID"

class CMainFrame
  : public CFrameWindowImpl<CMainFrame>
  , public CUpdateUI<CMainFrame>
  , public CMessageFilter
  , public CIdleHandler
{
public:
  DECLARE_FRAME_WND_CLASS(nullptr, IDR_MAINFRAME)

  CTrialTestExampleView m_view;

  CCommandBarCtrl m_CmdBar;

  CStringW mMP;
  CStringW mID;
  CStringW mCompID;

  BOOL PreTranslateMessage(MSG * pMsg) override
  {
    if (CFrameWindowImpl<CMainFrame>::PreTranslateMessage(pMsg))
      return TRUE;

    return m_view.PreTranslateMessage(pMsg);
  }

  BOOL OnIdle() override
  {
    UIUpdateToolBar();
    return FALSE;
  }

  BEGIN_UPDATE_UI_MAP(CMainFrame)
  UPDATE_ELEMENT(ID_VIEW_TOOLBAR, UPDUI_MENUPOPUP)
  UPDATE_ELEMENT(ID_VIEW_STATUS_BAR, UPDUI_MENUPOPUP)
  END_UPDATE_UI_MAP()

  BEGIN_MSG_MAP(CMainFrame)
  MESSAGE_HANDLER(WM_CREATE, OnCreate)
  MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
  MESSAGE_HANDLER(UM_TRIAL, OnTrial)
  COMMAND_ID_HANDLER(ID_APP_EXIT, OnFileExit)
  COMMAND_ID_HANDLER(ID_FILE_NEW, OnFileNew)
  COMMAND_ID_HANDLER(ID_VIEW_TOOLBAR, OnViewToolBar)
  COMMAND_ID_HANDLER(ID_VIEW_STATUS_BAR, OnViewStatusBar)
  COMMAND_ID_HANDLER(IDC_REGISTER_APP, OnRegister)
  COMMAND_ID_HANDLER(ID_APP_ABOUT, OnAppAbout)
  CHAIN_MSG_MAP(CUpdateUI<CMainFrame>)
  CHAIN_MSG_MAP(CFrameWindowImpl<CMainFrame>)
  END_MSG_MAP()

  // Handler prototypes (uncomment arguments if needed):
  //  LRESULT MessageHandler(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL&
  //  /*bHandled*/)
  //  LRESULT CommandHandler(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL&
  //  /*bHandled*/)
  //  LRESULT NotifyHandler(int /*idCtrl*/, LPNMHDR /*pnmh*/, BOOL& /*bHandled*/)

  LRESULT OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL & /*bHandled*/)
  {
    // create command bar window
    HWND hWndCmdBar = m_CmdBar.Create(m_hWnd, rcDefault, nullptr, ATL_SIMPLE_CMDBAR_PANE_STYLE);
    // attach menu
    m_CmdBar.AttachMenu(GetMenu());
    // load command bar images
    m_CmdBar.LoadImages(IDR_MAINFRAME);
    // remove old menu
    SetMenu(nullptr);

    HWND hWndToolBar =
      CreateSimpleToolBarCtrl(m_hWnd, IDR_MAINFRAME, FALSE, ATL_SIMPLE_TOOLBAR_PANE_STYLE);

    CreateSimpleReBar(ATL_SIMPLE_REBAR_NOBORDER_STYLE);
    AddSimpleReBarBand(hWndCmdBar);
    AddSimpleReBarBand(hWndToolBar, nullptr, TRUE);

    CreateSimpleStatusBar();

    m_hWndClient =
      m_view.Create(m_hWnd, rcDefault, nullptr,
                    WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN, WS_EX_CLIENTEDGE);

    UIAddToolBar(hWndToolBar);
    UISetCheck(ID_VIEW_TOOLBAR, 1);
    UISetCheck(ID_VIEW_STATUS_BAR, 1);

    // register object for message filtering and idle updates
    CMessageLoop * pLoop = _Module.GetMessageLoop();
    ATLASSERT(pLoop != nullptr);
    pLoop->AddMessageFilter(this);
    pLoop->AddIdleHandler(this);

    // Immediately after the main application windows is displayed show the trial dialog.
    ::PostMessage(m_hWnd, UM_TRIAL, 0, 0);
    return 0;
  }

  LRESULT OnDestroy(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL & bHandled)
  {
    // unregister message filtering and idle updates
    CMessageLoop * pLoop = _Module.GetMessageLoop();
    ATLASSERT(pLoop != nullptr);
    pLoop->RemoveMessageFilter(this);
    pLoop->RemoveIdleHandler(this);

    bHandled = FALSE;
    return 1;
  }

  LRESULT OnFileExit(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL & /*bHandled*/)
  {
    PostMessage(WM_CLOSE);
    return 0;
  }

  LRESULT OnFileNew(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL & /*bHandled*/)
  {
    // TODO: add code to initialize document

    return 0;
  }

  LRESULT OnTrial(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL & /*bHandled*/)
  {
    // Display the trial dialog.
    UINT ret = InitTrial::StartTrial(kLibraryKey, m_hWnd);

    // Trial dll is missing exit to protect the application.
    if (ret == InitTrial::MissingTrialDll)
      exit(0);

    // get license id
    DWORD len = mID.GetAllocLength();
    if (ERROR_MORE_DATA == InitTrial::GetPropertyValue(LICENSE_PROP_ID, mID.GetBuffer(), len))
    {
      InitTrial::GetPropertyValue(LICENSE_PROP_ID, mID.GetBufferSetLength(len), len);
    }

    // get license MP
    len = mMP.GetAllocLength();
    if (ERROR_MORE_DATA == InitTrial::GetPropertyValue(LICENSE_PROP_MP, mMP.GetBuffer(), len))
    {
      InitTrial::GetPropertyValue(LICENSE_PROP_MP, mMP.GetBufferSetLength(len), len);
    }

    // get license Computer ID
    len = mCompID.GetAllocLength();
    if (ERROR_MORE_DATA ==
        InitTrial::GetPropertyValue(LICENSE_PROP_COMP_ID, mCompID.GetBuffer(), len))
    {
      InitTrial::GetPropertyValue(LICENSE_PROP_COMP_ID, mCompID.GetBufferSetLength(len), len);
    }

    return 0;
  }

  LRESULT OnRegister(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL & /*bHandled*/)
  {
    // Display the trial dialog.
    InitTrial::DisplayRegistrationStub(kLibraryKey, m_hWnd);
    return 0;
  }

  LRESULT OnViewToolBar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL & /*bHandled*/)
  {
    static BOOL bVisible  = TRUE;  // initially visible
    bVisible              = !bVisible;
    CReBarCtrl rebar      = m_hWndToolBar;
    int        nBandIndex = rebar.IdToIndex(ATL_IDW_BAND_FIRST + 1);  // toolbar is 2nd added band
    rebar.ShowBand(nBandIndex, bVisible);
    UISetCheck(ID_VIEW_TOOLBAR, bVisible);
    UpdateLayout();
    return 0;
  }

  LRESULT OnViewStatusBar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL & /*bHandled*/)
  {
    BOOL bVisible = !::IsWindowVisible(m_hWndStatusBar);
    ::ShowWindow(m_hWndStatusBar, bVisible ? SW_SHOWNOACTIVATE : SW_HIDE);
    UISetCheck(ID_VIEW_STATUS_BAR, bVisible);
    UpdateLayout();
    return 0;
  }

  LRESULT OnAppAbout(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL & /*bHandled*/)
  {
    CAboutDlg dlg{ mMP, mID, mCompID };
    dlg.DoModal();
    return 0;
  }
};
