/*
 * Copyright 2002 - 2008 Caphyon LTD. All rights reserved.
 *
 * mailto: eng@caphyon.com
 * http://www.caphyon.com
 *
 */

#include "stdafx.h"
#include "InitTrial.h"

using TrialT     = UINT(WINAPI *)(LPCSTR, HWND);
using GetPropT   = UINT(WINAPI *)(LPCWSTR, LPWSTR, DWORD *);
using EnumPropsT = UINT(WINAPI *)(LPWSTR, DWORD *);

#define TrialFunctionName "ReadSettingsStr"
#define DisplayRegistrationFunctionName "DisplayRegistrationStr"
#define GetPropertyValueFunctionName "GetPropertyValue"
#define EnumeratePropertiesFunctionName "EnumerateProperties"
#define TrialDll L"Trial.dll"

AutoHandle InitTrial::hModule = ::LoadLibrary(TrialDll);

UINT InitTrial::StartTrial(LPCSTR aKeyCode, HWND aHWnd)
{
  return ReadSettingsStub(aKeyCode, aHWnd);
}

UINT InitTrial::DisplayRegistrationStub(LPCSTR aKeyCode, HWND aHWnd)
{
  if (hModule == nullptr)
    return MissingTrialDll;
  auto proc = reinterpret_cast<TrialT>(::GetProcAddress(hModule, DisplayRegistrationFunctionName));
  if (proc == nullptr)
    return MissingTrialDll;
  return (proc)(aKeyCode, aHWnd);
}

UINT InitTrial::ReadSettingsStub(LPCSTR aKeyCode, HWND aHWnd)
{
  if (hModule == nullptr)
    return MissingTrialDll;
  auto proc = reinterpret_cast<TrialT>(::GetProcAddress(hModule, TrialFunctionName));
  if (proc == nullptr)
    return MissingTrialDll;
  return (proc)(aKeyCode, aHWnd);
}

UINT InitTrial::EnumerateProperties(OUT LPWSTR aResult, IN OUT DWORD & aResultLen)
{
  if (hModule == nullptr)
    return MissingTrialDll;
  auto proc =
    reinterpret_cast<EnumPropsT>(::GetProcAddress(hModule, EnumeratePropertiesFunctionName));
  if (proc == nullptr)
    return MissingTrialDll;
  return (proc)(aResult, &aResultLen);
}

UINT InitTrial::GetPropertyValue(IN LPCWSTR aPropertyName,
                                 OUT LPWSTR aResult,
                                 IN OUT DWORD & aResultLen)
{
  if (hModule == nullptr)
    return MissingTrialDll;
  auto proc = reinterpret_cast<GetPropT>(::GetProcAddress(hModule, GetPropertyValueFunctionName));
  if (proc == nullptr)
    return MissingTrialDll;
  return (proc)(aPropertyName, aResult, &aResultLen);
}
