/*
 * Copyright 2002 - 2008 Caphyon LTD. All rights reserved.
 *
 * mailto: eng@caphyon.com
 * http://www.caphyon.com
 *
 */

#ifndef _AUTOHANDLE_H_
#define _AUTOHANDLE_H_

#ifndef __AFXWIN_H__
#error include 'stdafx.h' before including this file for PCH
#endif

/**
 * Helper class for automatically close a handle.
 */
class AutoHandle
{
public:
  AutoHandle(HMODULE aHandle = nullptr)
    : mHandle(aHandle)
  {
  }

  ~AutoHandle() { Reset(); }

  void Set(HMODULE aHandle)
  {
    Reset();

    mHandle = aHandle;
  }

  operator HMODULE() { return mHandle; }

  HMODULE * operator&()
  {
    Reset();

    return &mHandle;
  }

  HMODULE operator=(const HMODULE aRHS)
  {
    Set(aRHS);
    return *this;
  }

  void Reset()
  {
    if (mHandle)
    {
      ::FreeLibrary(mHandle);
      mHandle = nullptr;
    }
  }

private:
  HMODULE mHandle;
};

#endif  // _AUTOHANDLE_H_
