// aboutdlg.h : interface of the CAboutDlg class
//
/////////////////////////////////////////////////////////////////////////////

#pragma once

class CAboutDlg : public CDialogImpl<CAboutDlg>
{
public:
  enum
  {
    IDD = IDD_ABOUTBOX
  };

  BEGIN_MSG_MAP(CAboutDlg)
  MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
  COMMAND_ID_HANDLER(IDOK, OnCloseCmd)
  COMMAND_ID_HANDLER(IDCANCEL, OnCloseCmd)
  END_MSG_MAP()

  /**
   * Class constructor.
   */
  CAboutDlg(const CStringW & aMP, const CStringW & aID, const CStringW & aCompID)
    : mMP(aMP)
    , mID(aID)
    , mCompID(aCompID)
  {
  }

  /**
   * Init Method
   */
  LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL & /*bHandled*/)
  {
    CenterWindow(GetParent());

    ::SetWindowText(GetDlgItem(IDC_LIC_ID), mID);
    ::SetWindowText(GetDlgItem(IDC_LIC_MP), mMP);
    ::SetWindowText(GetDlgItem(IDC_LIC_COMP_ID), mCompID);

    return TRUE;
  }

  /**
   * Close Method
   */
  LRESULT OnCloseCmd(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL & /*bHandled*/)
  {
    EndDialog(wID);
    return 0;
  }

private:
  const CStringW & mMP;
  const CStringW & mID;
  const CStringW & mCompID;
};
