<?php

// server response codes
define('LICENSE_VALID',   '601');
define('LICENSE_INVALID', '602');

// database connection parameters
$db_host = 'localhost:3306';
$db_user = 'root';
$db_pass = 'root123';
$db_name = 'mydb';

// client information table
$clients_tbl_name = 'clients';
$sn_tbl_col       = 'serial_no';

/**
 * Server HTTP response to the query issued by Advanced Installer serial validation tool.
 */
function ServerResponse($is_valid, $posted_serial = '', $lang_id = 1033)
{
  $msg_sep = "\n";
  
  // load error messages from your database, using "$lang_id" for localization (optional)
  
  if($posted_serial == '')
    return LICENSE_INVALID . $msg_sep . "Missing Serial Number !";
  
  if($is_valid == true)
    return LICENSE_VALID;
  else
    return LICENSE_INVALID . $msg_sep . "Serial Number: " . $posted_serial . ' is invalid !';  
}

// Variables POSTed by Advanced Installer serial validation tool to this web page: "sn", "languageid".
if(isset($_POST['sn']) && trim($_POST['sn']) != '')
{
  // get the serial number entered by the installing user in the "UserRegistrationDlg" dialog 
  $sn = trim($_POST['sn']);
  
  // get the system language ID of the user's machine
  // (you can use this parameter to display a localized error message taken from your database)
  $languageid = (int) $_POST['languageid'];

  // get the additional information entered by the installing user in the "UserRegistrationDlg" dialog 
  $additional_information = $_POST['ai'];

  // connect to database
  $db_conn = @mysqli_connect($db_host, $db_user, $db_pass, $db_name);
  if(!$db_conn)
  {
    // issue error response
    echo ServerResponse(false, $sn, $languageid);
    die();
  }
  
  
  // prepare SQL statement
  $sn_query = "SELECT `". $sn_tbl_col ."` FROM `". $clients_tbl_name ."` WHERE `". $sn_tbl_col ."` = '" . mysqli_real_escape_string($db_conn, $sn) . "'";
  
  // execute query
  $result = @mysqli_query($db_conn, $sn_query);
  
  // get result set size
  if(@mysqli_num_rows($result) == 0)
  {
    // serial number NOT found in database => issue error response
    echo ServerResponse(false, $sn, $languageid);
    die();
  }
  else
  {
    // serial number was found in database => issue SUCCESS response
    echo ServerResponse(true, $sn, $languageid);
    die();
  }
}
else
{
  // issue error response
  echo ServerResponse(false);
  die();
}

?>