<?php

// server response codes
define('LICENSE_VALID',   '601');
define('LICENSE_INVALID', '602');

// database connection parameters
$db_host = 'localhost:3306';
$db_user = 'root';
$db_pass = 'root123';
$db_name = 'mydb';

// client information table
$clients_tbl_name = 'clients2';
$sn_tbl_col       = 'serial_no';
$lic_no_tbl_col   = 'license_no';
$val_no_tbl_col   = 'validations_no';

// serial validation results
$serial_invalid = 0;    // invalid serial
$serial_ok      = 1;    // valid serial
$val_exceeded   = 2;    // valid serial but maximum number of validations exceeded

/**
 * Server HTTP response to the query issued by Advanced Installer serial validation tool.
 * 
 * @param $valResult represents the result of the serial validation and has one of the 
 *                   above values: $serial_invalid, $serial_ok, $act_exceeded 
 */
function ServerResponse($valResult, $posted_serial = '', $lang_id = 1033)
{
  global $serial_invalid, $serial_ok, $val_exceeded;
  
  $msg_sep = "\n";
  
  // load error messages from your database, using "$lang_id" for localization (optional)
  
  if($posted_serial == '')
    return LICENSE_INVALID . $msg_sep . "Missing Serial Number !";
  
  switch($valResult)
  {
    case $val_exceeded:
      return LICENSE_INVALID . $msg_sep . 'Maximum number of validations exceeded for Serial Number: ' . $posted_serial;
    case $serial_ok:
      return LICENSE_VALID;
    default:
      return LICENSE_INVALID . $msg_sep . 'Serial Number: ' . $posted_serial . ' is invalid !';
  }
}

// Variables POSTed by Advanced Installer serial validation tool to this web page: "sn", "languageid".
if(isset($_POST['sn']) && trim($_POST['sn']) != '')
{
  // get the serial number entered by the installing user in the "UserRegistrationDlg" dialog 
  $sn = trim($_POST['sn']);
  
  // get the system language ID of the user's machine
  // (you can use this parameter to display a localized error message taken from your database)
  $languageid = (int) $_POST['languageid'];
  
  // connect to database
  $db_conn = @mysqli_connect($db_host, $db_user, $db_pass, $db_name);
  if(!$db_conn)
  {
    // issue error response
    echo ServerResponse($serial_invalid, $sn, $languageid);
    die();
  }
  
  
  // prepare SQL statement
  $sn_query = sprintf("SELECT `%s`, `%s`, `%s` FROM `%s` WHERE `%s` = '%s'", 
    $sn_tbl_col, $lic_no_tbl_col, $val_no_tbl_col, 
    $clients_tbl_name, $sn_tbl_col, mysqli_real_escape_string($db_conn, $sn));
  
  // execute query
  $result = @mysqli_query($db_conn, $sn_query);
  
  // get result set size
  if(@mysqli_num_rows($result) == 0)
  {
    // serial number NOT found in database => issue error response
    echo ServerResponse($serial_invalid, $sn, $languageid);
    die();
  }
  else // serial number was found in database
  {
    // fetch the result row as an associative array 
    $row = @mysqli_fetch_array($result, MYSQLI_ASSOC);
    if(!$row)
    {
      // issue error response
      echo ServerResponse($serial_invalid, $sn, $languageid);
      die();
    }
    
    // increment the validations_no column
    $inc_val_no_query = sprintf("UPDATE `%s` SET `%s` = `%s` + 1 WHERE `%s` = '%s'",
      $clients_tbl_name, $val_no_tbl_col, $val_no_tbl_col, 
      $sn_tbl_col, mysqli_real_escape_string($db_conn, $sn));
    
    // execute the update query
    @mysqli_query($db_conn, $inc_val_no_query);

    // check whether the user has reached maximum number of validations
    $license_no    = (int) $row[ $lic_no_tbl_col ];
    $validation_no = (int) $row[ $val_no_tbl_col ];
    
    if($validation_no >= $license_no)
    {
      // issue error response => maximum number of validations exceeded
      echo ServerResponse($val_exceeded, $sn, $languageid);
      die();
    }
    else
    {
     // issue SUCCESS response
     echo ServerResponse($serial_ok, $sn, $languageid);
     die();
    }
  }
}
else
{
  // issue error response
  echo ServerResponse($serial_invalid);
  die();
}

?>

