-- --------------------------------------------------------
--
-- Database: `mydb`
--

CREATE DATABASE IF NOT EXISTS `mydb` DEFAULT CHARACTER SET utf8 COLLATE utf8_bin;
USE `mydb`;

-- --------------------------------------------------------
--
-- Table structure for table `clients`
--

CREATE TABLE IF NOT EXISTS `clients` (
  `client_id` int(10) unsigned NOT NULL auto_increment,
  `user_name` varchar(255) collate utf8_bin NOT NULL,
  `company` varchar(255) collate utf8_bin NOT NULL,
  `email` varchar(255) collate utf8_bin NOT NULL,
  `serial_no` varchar(255) collate utf8_bin NOT NULL,
  `additional_information` TEXT collate utf8_bin NOT NULL,
  PRIMARY KEY  (`client_id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `serial` (`serial_no`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Our company clients' AUTO_INCREMENT=3;

--
-- Dumping data for table `clients`
--

INSERT INTO `clients` (`client_id`, `user_name`, `company`, `email`, `serial_no`, `additional_information`) VALUES
(1, 'John Doe', 'User Comp.', 'johnd@domain.com', '233-421-752-325', 'additional information'),
(2, 'User Name', 'Home', 'email@domain.com', '444-555-222-243', 'additional information');
